-- events for shaman screen

T_INFO_MOUSE_OVER = Localize ("Hover the cursor over a powerup for information.");


T_COMPLETE = Localize ("Completed: ");

timer = 0
floweramount = 25;
flowerpositions = {}

MAX_TALISMAN_SLOTS = 1;
TOTAL_NUM_TALISMANS = 9;

selected_talisman = "!NONE";

complete = 0

function OnLoad ()
	CacheSound ("music/shaman.ogg");
	CacheSound("sfx/whoosh1.ogg")
	NX_GetBitmap("board/piece-short.png");
	NX_GetBitmap("ui/gfx/starbig-off.png");
end;

function UpdateTalismanDesc ()

	index = Azkend_GetSlotPowerup (0);
	name = Azkend_GetPowerupName (index);
	desc = Azkend_GetPowerupDesc (index);
	if(name == "!NONE") then
		return;
	end;
	SetProperty ("name:label.text", name);
	SetProperty ("desc:label.text", desc);
	SetProperty ("big_talisman_bm:label.bitmap", Azkend_GetPowerupBitmapBig (index));
	
	level_reached = Azkend_GetSurvivalTalismanLevelReached (selected_talisman);
end;


function ShowAllAmuletButtons ()

	num = Azkend_GetNumPowerups ();
	i = 0;
	while (i < num) do
		id = Azkend_GetPowerupID (i);
		--Print ("Showing #" .. i .. ": '" .. id .. "'\n");
		SetProperty ("Amulet_" .. id .. ":visible", 1);
		i = i + 1;
	end;

	--SetProperty ("Amulet_Fire:visible", 1);
	--SetProperty ("Amulet_Waterfall:visible", 1);
	--SetProperty ("Amulet_WaterCross:visible", 1);
	--SetProperty ("Amulet_Luck:visible", 1);
end;



function UpdateProgress ()

	num = Azkend_GetNumPowerups ();
	i = 0;
	while (i < num) do
		id = Azkend_GetPowerupID (i);
		progress = 10*Azkend_GetSurvivalTalismanLevelReached ("Amulet_"..id);
		SetProperty (id.."_Progress:label.text", progress.. "%");
		i = i + 1;
	end;
end;



function HideAllAmuletButtons ()

	num = Azkend_GetNumPowerups ();
	i = 0;
	while (i < num) do
		id = Azkend_GetPowerupID (i);
		--Print ("Hiding #" .. i .. ": '" .. id .. "'\n");
		SetProperty ("Amulet_" .. id .. ":visible", 0);
		i = i + 1;
	end;
end;




function UpdatePowerupIcons ()
	
	ShowAllAmuletButtons ();
	
	
	i = 1;
	
	while (i <= TOTAL_NUM_TALISMANS) do
		name = Azkend_GetPowerupID(i-1);
		
		active = GetGameValue ("powerup_unlocked_".. name);
		--Print (i .. " is " .. name .. "\n");

		SetProperty ("Amulet_"..name..":active", 1);
		
		if (active) then
			SetProperty ("Amulet_"..name..":visible", 1);
		else
			SetProperty ("Amulet_"..name..":visible", 0);
		end;
		
	

		i = i + 1;
	end;
	
	--Print ("Listed.\n");

	i = 0;
	while (i < MAX_TALISMAN_SLOTS) do
		index = Azkend_GetSlotPowerup (i);
		SetProperty ("Slot" .. (i+1) .. ":button.bm_icon", Azkend_GetPowerupBitmap (index));
	  
		id = Azkend_GetPowerupID (index);

		--Print ("Slot " .. i .. "id is " .. id .. "\n");

		SetProperty ("Amulet_" .. id .. ":active", 0);

		i = i + 1;
	end;
	

end;

phase = 0;

function OnEnter ()
	phase = 0;
	
	if (not IsSetProfileVar ("SurvivalTalisman")) then
		SetProfileVar ("SurvivalTalisman", "Amulet_JadeBomb");
	end;
	
	selected_talisman = GetProfileVar ("SurvivalTalisman");
	
	if (selected_talisman == "!NONE") then
	  
	  	Print ("None selected, selecting JadeBomb...\n");
	  	name = "Amulet_JadeBomb";
	  	selected_talisman = name;

  		Azkend_SelectPowerup (name);

		--index = Azkend_GetSlotPowerup (0);
		--Azkend_UnselectPowerup (index);
		
		--Azkend_SelectPowerup (name);
	end;
	
    PlaySound("sfx/whoosh1.ogg")
	UpdatePowerupIcons ();
 	SetProperty ("/:enter_trans_duration", 0.45);
    SetProperty ("/:leave_trans_duration", 0.45);
	SwitchMusic ("music/shaman.ogg", 2, 3);
	
	for i = 1, floweramount, 1 do
  		temp = {}
		y = math.random(40,700);
		temp.y = y - (y*2);		
		temp.x = math.random(0,800);
		table.insert(flowerpositions, i, temp);
  	end;
  	
  UnlockReached ();


	UpdatePowerupIcons ();
	UpdateTalismanDesc ();
	
	level_reached = Azkend_GetSurvivalTalismanLevelReached (selected_talisman);
	
	OnClick (selected_talisman);


end;

function OnLeave ()

end;



function UnlockAll ()
	--Print ("Unlocking all powerups...\n");
	i = 1;
	while (i <= TOTAL_NUM_TALISMANS) do
		SetGameValue ("powerup_unlocked_".. Azkend_GetPowerupID(i-1),  true);
		i = i + 1;
	end;
	--SetGameValue ("powerup_unlocked_JadeBomb", false);

end;

function LockAll ()
	--Print ("Locking all powerups...\n");
	i = 1;
	while (i <= TOTAL_NUM_TALISMANS) do
		name = Azkend_GetPowerupID(i-1);
		--Print ("Locking " .. name .. "\n");
		SetGameValue ("powerup_unlocked_"..name, false);
		i = i + 1;
	end;
	
end;


function UnlockReached ()
	LockAll ();
	--Print ("Unlocking unlocked powerups :)\n");
	i = 1;
	num_unlocked = Azkend_GetNumTalismansUnlocked ();
	while (i <= num_unlocked) do
		name = "powerup_unlocked_".. Azkend_GetPowerupID(i-1);
		--Print ("its " .. name .. "\n");
		SetGameValue (name,  true);
		i = i + 1;
	end;
	--SetGameValue ("powerup_unlocked_JadeBomb", false);
	UpdatePowerupIcons ();


end;

function OnClick (name)

	--Print ("OnClick " .. name .. "\n");
		
	if (name == "Ok") then	
	    PlaySound("sfx/whoosh1.ogg")
		SwitchScreen("MainMenu");
		return;
	end;
	
	
	
	if (name == "Play") then

		InitNewGame ();
		Azkend_SetGameMode (GetVar ("GameMode"));
		
		Azkend_SelectSurvivalTalisman (selected_talisman);
			
		SetGameLevel (1);
		InitGameLevel ();
		SwitchScreen ("Game");
	end;
		
	
	if (name == "Unlock All") then
		UnlockAll ();		
		UpdatePowerupIcons ();
	end;		
	if (name == "Lock All") then
		LockAll ();		
		UpdatePowerupIcons ();
	end;	


	-- For testing purposes (see if all powerups are included in string search)
	if (name == "Hide") then
		HideAllAmuletButtons ();
	end;
	if (name == "Show") then
		ShowAllAmuletButtons ();
	end;

	-- Add powerups to slots on click (provided there's space)
	if (string.find(name, "Amulet_")) then
			timer = 0;
			phase = 0;
			index = Azkend_GetSlotPowerup (0);
			SetProfileVar ("SurvivalTalisman", name)
			Azkend_UnselectPowerup (index);
			Azkend_SelectPowerup (name);
			UpdatePowerupIcons ();
			selected_talisman = name;
			UpdateTalismanDesc ();

	end;

	-- Remove powerups from the slots on click
	i = 0;
	while (i < MAX_TALISMAN_SLOTS) do
		slot_name = "Slot" .. (i+1);
		if (name == slot_name) then
			index = Azkend_GetSlotPowerup (i);
			Azkend_UnselectPowerup (index);
			UpdatePowerupIcons ();
		end;
		i = i + 1;
	end;

	
end;

function clamp (value, min, max)

	if (value < min) then
		value = min;
	end;

	if (value > max) then
		value = max;
	end;
	
	return value;
end;


function OnUpdate (tdelta)

	local i = 0;
	
	UpdateProgress ();

	timer = timer + tdelta;
	if (timer > 0 and phase < 2*(timer-0.3-0.15)/0.3 and phase < level_reached and phase < 10) then
		phase = phase + 1;
		chan = NX_PlaySound ("sfx/awardingsound01.ogg");
		NX_SetChanFrequence (chan, 0.9 + phase * 0.1);
	end;
	
	alpha = GetActiveScreenTransPhase ();
	
	trans = math.sin (0.5*3.1415926535 * GetActiveScreenTransPhase ());
	--SetProperty ("panel:position_offset.y", (1-trans) * 600);
	
	SetProperty ("fader:alpha", alpha);
	
	SetProperty ("panel:alpha", GetActiveScreenTransPhase ());
	
	complete = Azkend_GetSurvivalTalismanLevelReached (selected_talisman) / 10.0;--math.abs(math.sin(timer))
	complete_int = string.format("%u", complete*100);
	
	local total_complete = 0;
	for i = 1, 8, 1 do
	
		local name = Azkend_GetPowerupID (i);
		complete = Azkend_GetSurvivalTalismanLevelReached (name) / 10.0;
		total_complete = total_complete + clamp(100*complete, 0, 100);
		
		

	end;
	
	local total_complete_int = string.format("%u", total_complete/8);
	
	SetProperty ("complete:label.text", T_COMPLETE..total_complete_int.."%");

	
	for i = 1, floweramount, 1 do
		if(flowerpositions[i]["y"] < 700) then
			flowerpositions[i]["y"] = flowerpositions[i]["y"] + (30 * tdelta);		
		else	
  			--Print("ENDFLOWERFLY flower" .. i .. "\n");
  			y = math.random(40,700);
			y = y - (y*2);		
			x = math.random(0,800);
			flowerpositions[i]["y"] = y
			flowerpositions[i]["x"] = x
		end;
		
	end;
	
end;


function clamp (value, min_value, max_value)
	value = math.min (value, max_value);
	value = math.max (value, min_value);
	return value;
end;


function DrawStars ()
	i = 0;
	
	NX_SetBlend ("NORMAL");
	NX_SetColor (1,1,1);

 	alpha = GetProperty ("panel:alpha");
 	

	while (i < 10) do

		x = GetProperty ("star_pos:static_position.x");
		y = GetProperty ("star_pos:static_position.y");
		
		x = x + i * 40;
		
		NX_SetAlpha (alpha);
		NX_DrawBitmapRS ("ui/gfx/starbig-off.png", x, y, 0, 1);
		
		t = clamp (2*timer - i*0.3, 0, 1);
		y = y + clamp ((1-t)*200, 0, 200);
		
		scale = 1+clamp ((1-t)*3, 0, 1);
		NX_SetAlpha (alpha*clamp (t, 0, 1));

		if (i < level_reached) then
			NX_DrawBitmapRS ("ui/gfx/starbig-on.png", x, y, 0, scale);
		end;


		i = i + 1;
	end;
end;





function OnDraw ()
	--NX_SetBlend ("ADDITIVE")
	if (false) then
	for i = 1, floweramount, 1 do
		sinewave = 35 * math.sin((flowerpositions[i]["y"] / 80));
		rotationsine = 155 * math.sin((flowerpositions[i]["y"] / 30));
		--scale = flowerpositions[i]["y"] / 800 + 0.5;
		
		scale = math.sin((flowerpositions[i]["y"] / 30))/6 + 1
		NX_DrawBitmapRS ("board/piece-short.png", flowerpositions[i]["x"]+sinewave, flowerpositions[i]["y"], rotationsine/180*3.1415926535, scale);
	end;
	end;
	--NX_SetBlend ("NORMAL")
	
	font = GetProperty ("name:label.font");
	alpha = GetActiveScreenTransPhase ();

	NX_SetAlpha (alpha);

	NX_SetColor (1,0.5,0.1);
	x = GetProperty ("name:static_position.x");
	y = GetProperty ("name:static_position.y");
	
	DrawStars ();
	


--	NX_DrawText (font, x, y, name);


	NX_SetColor (1,1,1);
	x = GetProperty ("desc:static_position.x");
	y = GetProperty ("desc:static_position.y");

--	NX_DrawText (font, x, y, "desc");

end;

